from tabular_data import Table
class ShoppingCart:
    def __init__(self):
        self._products=set()
    def __call__(self,product):
        self._products.add(product)
    def contains(self,product):
        return product in self._products
    def clear(self):
        self._products=set()
    def __str__(self):
        t=Table(['Product Name', 'Product Price'],\
                    [p.name for p in self._products],\
                    [p.price for p in self._products])
        return str(t)
